 ; Ŀ
 ;   TTB - suck text into blocks by rows.                                  
 ;   Copyright 1995, 2000, 2002 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Candy - put a data list into blocks.                                  
 ;   Takes one argument: a data list.                                      
 ;   Also asks for some atuff on its own.                                  
 ; 
 (DEFUN CANDY (malist / blnam pa vdist sub)
  (setvar "attreq" 1)
 ; Ŀ
 ;   Get a block name by selection.                                        
 ; 
  (if (setq blnam (entsel "\nSelect Block: "))
      (setq blnam (cdr (assoc 2 (entget (car blnam))))))
 ; Ŀ
 ;   Start point.                                                          
 ; 
  (setq pa (getpoint "\nStart Point: "))
 ; Ŀ
 ;   Vertical distance.                                                    
 ; 
  (setq vdist (getdist pa "\nVertical Spacing: "))
 ; Ŀ
 ;   Insert blocks while there are sublists in the master list.            
 ; 
  (while (setq sub (car malist))
         (setq malist (cdr malist))
         (insbloc blnam pa sub)
         (setq pa (polar pa (* pi 1.5) vdist)))
 (princ))
 ; Ŀ
 ;   Subroutine Candy end.                                                 
 ; 

 ; Ŀ
 ;   Insbloc - insert a block.                                             
 ;   Takes three arguments: Blnam, the block name.                         
 ;                          Pa, the insertion point.                       
 ;                          Llist, the attribute value list.               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN INSBLOC (blnam pa llist / nexstr)
 ; Ŀ
 ;   Insert a data block, read the values from the string list Llist into  
 ;   the attributes.                                                       
 ; 
  (command ".insert" blnam pa "" "" "")
  (while (and (setq nexstr (car llist))
              (= 1 (getvar "cmdactive")))
         (setq llist (cdr llist))
         (command nexstr))
 ; Ŀ
 ;   Fill leftover attributes with empty strings.                          
 ; 
  (while (= 1 (getvar "cmdactive")) (command "")))
 ; Ŀ
 ;   Insbloc end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   TTB.                                                                  
 ; 
 (DEFUN C:TTB (/ ss fuzzp fuzz malist)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get entities.                                                         
 ; 
  (if (setq ss (ssget (list (cons 0 "text"))))
      (progn
 ; Ŀ
 ;   Get a fuzz value for position equality.                               
 ; 
          (setq fuzzp (cdr (assoc 40 (entget (ssname ss 0)))))
          (setq fuzz (getdist (strcat "\nPositional inaccuracy allowance <"
                                       (rtos fuzzp 2 2) ">:")))
          (if (null fuzz) (setq fuzz fuzzp))
 ; Ŀ
 ;   Call Snort to make the text values into a grid.                       
 ; 
          (if (null (load "snort" ()))
              (prompt "Incipient crash: Snort.lsp not available."))
          (setq malist (snort ss fuzz))))
 ; Ŀ
 ;   Erase the text, call Candy to insert the blocks.                      
 ; 
  (if malist
      (progn
           (command ".erase" ss "")
           (candy malist)))
 (princ))